package decoratorexample;

import java.util.Iterator;
import java.util.List;

public class StatLineWriterDecorator extends LineWriterDecorator {

    public StatLineWriterDecorator(LineWriter lw) {
        super(lw);
    }

    public void printAllLines(List<String> storage) {
        super.printAllLines(storage);
        makeStatistics(storage);
    }

    protected void makeStatistics(List<String> storage) {
        int tot = 0;
        Iterator<String> it = storage.iterator();
        while (it.hasNext()) {
            tot += it.next().length();
        }
        System.out.println("Totale caratteri: " + tot);
    }
}
